<?php
/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */

namespace Shopware\Bundle\ESIndexingBundle;

use Shopware\Bundle\StoreFrontBundle\Struct\Shop;
use Shopware\Bundle\StoreFrontBundle\Struct\ShopContextInterface;

/**
 * Class FieldMapping
 */
class FieldMapping implements FieldMappingInterface
{
    /**
     * @var ShopAnalyzerInterface
     */
    private $shopAnalyzer;

    /**
     * @var TextMappingInterface
     */
    private $textMapping;

    public function __construct(
        ShopAnalyzerInterface $shopAnalyzer,
        TextMappingInterface $textMapping
    ) {
        $this->shopAnalyzer = $shopAnalyzer;
        $this->textMapping = $textMapping;
    }

    /**
     * @return string
     */
    public function getPriceField(ShopContextInterface $context)
    {
        $key = $context->getCurrentCustomerGroup()->getKey();
        $currency = $context->getCurrency()->getId();

        return 'calculatedPrices.' . $key . '_' . $currency . '.calculatedPrice';
    }

    /**
     * @return array
     */
    public function getLanguageField(Shop $shop)
    {
        $analyzers = $this->shopAnalyzer->get($shop);

        $fields = [
            'raw' => $this->textMapping->getNotAnalyzedField(),
        ];

        foreach ($analyzers as $analyzer) {
            $key = $analyzer . '_analyzer';

            $fields[$key] = array_merge(
                $this->textMapping->getTextField(),
                ['analyzer' => $analyzer]
            );
        }

        return array_merge(
            $this->textMapping->getTextField(),
            ['fields' => $fields]
        );
    }
}
